<?php
include 'header.php';
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

$packs = $conn->query("SELECT * FROM mixing_packs");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mixing Packs</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .card {
      border-radius: 10px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }
    .mixing-item {
      font-size: 14px;
      line-height: 1.6;
    }
    .add-btn {
      font-size: 14px;
      padding: 6px 12px;
    }
  </style>
</head>
<body>
<div class="container py-5">
  <h2 class="text-center mb-4">Mixing Pack - Special Offers</h2>
  <div class="row">
    <?php while ($pack = $packs->fetch_assoc()): ?>
      <?php
        $pack_id = $pack['id'];
        $items = $conn->query("SELECT item_name, quantity FROM mixing_pack_items WHERE pack_id = $pack_id");
      ?>
      <div class="col-md-4 mb-4">
        <div class="card p-3 h-100">
          <h5><?= htmlspecialchars($pack['name']) ?></h5>
          <ul class="mixing-item">
            <?php while ($item = $items->fetch_assoc()): ?>
              <li><?= htmlspecialchars($item['item_name']) ?> - <?= $item['quantity'] ?></li>
            <?php endwhile; ?>
          </ul>
          <div class="d-flex justify-content-between align-items-center">
            <span class="fw-bold text-success">₹<?= number_format($pack['price'], 2) ?></span>
            <button class="btn btn-outline-primary btn-sm add-btn" onclick='addToCart(<?= json_encode($pack) ?>)'>🛒 Add to Cart</button>
          </div>
        </div>
      </div>
    <?php endwhile; ?>
  </div>
</div>

<script>
function addToCart(pack) {
  let cart = JSON.parse(localStorage.getItem("cart") || "[]");
  cart.push({
    productId: "mixpack_" + pack.id,
    name: pack.name,
    price: parseFloat(pack.price),
    total: parseFloat(pack.price),
    pages: 1 // placeholder for compatibility
  });
  localStorage.setItem("cart", JSON.stringify(cart));
  alert("Added " + pack.name + " to cart!");
  updateCartCount();
}

function updateCartCount() {
  const cart = JSON.parse(localStorage.getItem("cart") || "[]");
  const badge = document.getElementById("cart-count");
  if (badge) badge.textContent = cart.length;
}
updateCartCount();
</script>
</body>
</html>
