<?php
session_start();
require 'tcpdf/tcpdf.php';

// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    die('Not logged in');
}

if (!isset($_GET['order_id'])) {
    die('Order ID not provided');
}

$order_id = intval($_GET['order_id']);
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

if ($conn->connect_error) {
    die('Database connection failed: ' . $conn->connect_error);
}

try {
    // Get order details
    $order_query = $conn->prepare("
        SELECT o.*, u.name as user_name, u.mobile as mobile_number 
        FROM orders o
        JOIN users u ON o.user_id = u.id
        WHERE o.id = ?
    ");
    
    if (!$order_query) {
        throw new Exception('Prepare failed: ' . $conn->error);
    }
    
    $order_query->bind_param('i', $order_id);
    $order_query->execute();
    $order = $order_query->get_result()->fetch_assoc();

    if (!$order) {
        throw new Exception('Order not found');
    }

    // Get order items
    $items_query = $conn->prepare("
        SELECT * FROM order_items 
        WHERE order_id = ?
    ");
    
    if (!$items_query) {
        throw new Exception('Prepare failed: ' . $conn->error);
    }
    
    $items_query->bind_param('i', $order_id);
    $items_query->execute();
    $items = $items_query->get_result()->fetch_all(MYSQLI_ASSOC);

    // Create new PDF document
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // Set document information
    $pdf->SetCreator('Savithri Digital');
    $pdf->SetAuthor('Savithri Digital');
    $pdf->SetTitle('Order #' . $order['order_number']);
    $pdf->SetSubject('Order Details');

    // Remove default header/footer
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    // Add a page
    $pdf->AddPage();

    // Set font
    $pdf->SetFont('helvetica', '', 12);

    // Add content
    $html = '
    <h1 style="text-align:center;color:#1a5276;">Order Details</h1>
    <table border="0" cellpadding="5">
        <tr>
            <td width="30%"><strong>Order Number:</strong></td>
            <td>' . htmlspecialchars($order['order_number']) . '</td>
        </tr>
        <tr>
            <td><strong>Order Date:</strong></td>
            <td>' . date('F j, Y', strtotime($order['created_at'])) . '</td>
        </tr>
        <tr>
            <td><strong>Customer Name:</strong></td>
            <td>' . htmlspecialchars($order['user_name']) . '</td>
        </tr>
        <tr>
            <td><strong>Mobile:</strong></td>
            <td>' . htmlspecialchars($order['mobile_number']) . '</td>
        </tr>
    </table>';

    // Add items table
    $html .= '
    <h3 style="margin-top:20px;">Order Items</h3>
    <table border="1" cellpadding="5">
        <tr style="background-color:#f2f2f2;">
            <th width="40%">Product</th>
            <th width="15%">Type</th>
            <th width="15%">Quantity</th>
            <th width="15%">Price</th>
            <th width="15%">Total</th>
        </tr>';

    $subtotal = 0;
    foreach ($items as $item) {
        $total = $item['price'] * $item['quantity'];
        $subtotal += $total;
        
        $html .= '
        <tr>
            <td>' . htmlspecialchars($item['product_name']) . '</td>
            <td>' . ucfirst(htmlspecialchars($item['product_type'])) . '</td>
            <td>' . $item['quantity'] . '</td>
            <td>₹' . number_format($item['price'], 2) . '</td>
            <td>₹' . number_format($total, 2) . '</td>
        </tr>';
    }

    // Add totals
    $html .= '
        <tr>
            <td colspan="4" style="text-align:right;"><strong>Subtotal:</strong></td>
            <td><strong>₹' . number_format($subtotal, 2) . '</strong></td>
        </tr>
    </table>';

    // Print text using writeHTML()
    $pdf->writeHTML($html, true, false, true, false, '');

    // Close and output PDF document
    $pdf->Output('order_' . $order['order_number'] . '.pdf', 'I');

} catch (Exception $e) {
    // Log the error
    error_log('PDF Generation Error: ' . $e->getMessage());
    error_log('Stack trace: ' . $e->getTraceAsString());
    
    // Show a user-friendly error message
    die('Error generating PDF. Please try again later. ' . $e->getMessage());
} finally {
    if (isset($conn)) {
        $conn->close();
    }
}