<?php
session_start();
include 'header.php';


// DB connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

// Ensure user is logged in
if (!isset($_SESSION['email'])) {
    die("You must log in first.");
}

$user_email = $_SESSION['email'];

// Fetch user's region
$user_stmt = $conn->prepare("SELECT region FROM users WHERE email = ?");
$user_stmt->bind_param("s", $user_email);
$user_stmt->execute();
$user_res = $user_stmt->get_result();

if ($user_res->num_rows === 0) {
    die("User not found.");
}

$user_data = $user_res->fetch_assoc();
$user_region = strtolower(trim($user_data['region']));

// Select price column based on region
$price_column = ($user_region === "region 2") ? "price_region" : "price";

// Fetch add-on products with correct price column
$results = $conn->query("SELECT id, name, note, $price_column AS price FROM addon_products");
?>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
  .addon-card {
    border-radius: 15px;
    transition: 0.3s;
  }
  .addon-card:hover {
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    transform: translateY(-3px);
  }
  .price {
    font-weight: bold;
    color: #0d6efd;
  }
  .cart-btn {
      background-color:#2c3169;
      border: none;
      padding: 5px 10px;
      margin-left: 29px;
      color: white;
      border-radius: 5px;
      font-size: 14px;
      cursor: pointer;
    }
  .cart-btn:hover {
    color: #2c3169;
    background:white;
  }
</style>

<div class="container mt-5">
  <h2 class="mb-4">Other Add-ons</h2>
  <div class="row">
    <?php while ($row = $results->fetch_assoc()): ?>
    <div class="col-md-4 mb-4">
      <div class="card addon-card p-3 h-100">
        <div class="d-flex justify-content-between align-items-start">
          <div>
            <h5 class="mb-1"><?= htmlspecialchars($row['name']) ?></h5>
            <p class="small text-muted"><?= htmlspecialchars($row['note']) ?></p>
            <p class="price">₹<?= number_format($row['price'], 2) ?></p>
          </div>
          <button class="cart-btn" onclick='addToCart(<?= json_encode($row) ?>)' title="Add to Cart">
            <i class="bi bi-cart-plus"></i>
          </button>
        </div>
      </div>
    </div>
    <?php endwhile; ?>
  </div>
</div>

<script>
function addToCart(product) {
  let cart = JSON.parse(localStorage.getItem("cart") || "[]");
  cart.push({ ...product, categoryId: 'addons', total: product.price });
  localStorage.setItem("cart", JSON.stringify(cart));
  alert("Added to cart!");
}
</script>
