<?php
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get and validate print_category_id
$print_category_id = $_GET['print_category_id'] ?? null;
if (!$print_category_id || !is_numeric($print_category_id)) {
    die("Invalid or missing category ID.");
}

// Fetch packages
$packages = $conn->query("SELECT * FROM packages WHERE print_category_id = $print_category_id");
?>

<?php include 'header.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= htmlspecialchars($category_name) ?> - Savithri Digital</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <style>
    :root {
      --primary: #6c5ce7;
      --secondary: #00cec9;
      --accent: #ff6b6b;
      --dark: #2d3436;
      --light: #f8f9fa;
    }
    
    body {
      background: #f5f7fa;
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      padding-bottom: 30px;
    }
    
    .header {
      background: white;
      padding: 15px 0;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
      margin-bottom: 20px;
    }
    
    .page-title {
      font-size: 1.8rem;
      font-weight: 700;
      color: var(--dark);
      margin: 0;
      text-align: center;
      background: linear-gradient(45deg, var(--primary), var(--secondary));
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      display: inline-block;
    }
    
    .packages-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 15px;
      padding: 0 15px;
      max-width: 800px;
      margin: 0 auto;
    }
    
    .package-card {
      background: white;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 3px 15px rgba(0,0,0,0.05);
      transition: all 0.3s ease;
      text-decoration: none;
      color: var(--dark);
      display: flex;
      flex-direction: column;
    }
    
    .package-card:active {
      transform: scale(0.98);
    }
    
    .package-image-container {
      position: relative;
      padding-top: 100%;
      background: #f8f9fa;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .package-image {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: contain;
      padding: 20px;
      transition: transform 0.3s ease;
    }
    
    .package-badge {
      position: absolute;
      top: 10px;
      right: 10px;
      background: var(--accent);
      color: white;
      font-size: 0.7rem;
      padding: 3px 10px;
      border-radius: 10px;
      font-weight: 600;
    }
    
    .package-details {
      padding: 15px;
      text-align: center;
    }
    
    .package-name {
      font-size: 0.95rem;
      font-weight: 600;
      margin: 0 0 8px;
      display: -webkit-box;
      -webkit-line-clamp: 2;
      -webkit-box-orient: vertical;
      overflow: hidden;
      min-height: 2.8em;
    }
    
    .package-price {
      font-weight: 700;
      color: var(--primary);
      font-size: 1.1rem;
      margin: 5px 0 0;
    }
    
    .view-btn {
      display: inline-block;
      background: var(--primary);
      color: white;
      padding: 8px 15px;
      border-radius: 8px;
      text-decoration: none;
      font-weight: 500;
      font-size: 0.85rem;
      margin-top: 12px;
      transition: all 0.3s ease;
      width: 100%;
      text-align: center;
    }
    
    .view-btn:active {
      background: var(--dark);
    }
    
    /* Responsive Adjustments */
    @media (min-width: 768px) {
      .packages-grid {
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
        padding: 0 20px;
      }
    }
    
    @media (min-width: 992px) {
      .packages-grid {
        grid-template-columns: repeat(4, 1fr);
        max-width: 1200px;
      }
    }
  </style>
</head>
<body>
  <header class="header">
    <div class="container">
      <h1 class="page-title"><?= htmlspecialchars($category_name) ?></h1>
    </div>
  </header>
  
  <main>
    <div class="packages-grid">
      <?php if ($packages->num_rows > 0): ?>
        <?php while($row = $packages->fetch_assoc()): ?>
          <a href="products.php?package_id=<?= $row['id'] ?>" class="package-card">
            <div class="package-image-container">
              <?php if (!empty($row['image'])): ?>
                <img src="images/<?= htmlspecialchars($row['image']) ?>" 
                     alt="<?= htmlspecialchars($row['name']) ?>" 
                     class="package-image"
                     onerror="this.onerror=null; this.src='https://test.kalpavrukshaits.com/savithridigital/images/package.png'">
              <?php else: ?>
                <img src="https://test.kalpavrukshaits.com/savithridigital/images/package.png" 
                     alt="Default Package" 
                     class="package-image">
              <?php endif; ?>
            </div>
            <div class="package-details">
              <h3 class="package-name"><?= htmlspecialchars($row['name']) ?></h3>
              <?php if (isset($row['price']) && $row['price'] > 0): ?>
                <p class="package-price">₹<?= number_format($row['price'], 2) ?></p>
              <?php else: ?>
                
              <?php endif; ?>
              <span class="view-btn">Select</span>
            </div>
          </a>
        <?php endwhile; ?>
      <?php else: ?>
        <div style="grid-column: 1 / -1; text-align: center; padding: 40px 20px; background: white; border-radius: 12px; box-shadow: 0 3px 15px rgba(0,0,0,0.05);">
          <i class="fas fa-inbox" style="font-size: 3rem; color: #dee2e6; margin-bottom: 15px;"></i>
          <h4 style="color: var(--dark); margin-bottom: 10px;">No Packages Found</h4>
          <p style="color: #6c757d; margin: 0;">We couldn't find any packages in this category.</p>
        </div>
      <?php endif; ?>
    </div>
  </main>

  <script>
    // Simple touch feedback
    document.addEventListener('DOMContentLoaded', function() {
      const cards = document.querySelectorAll('.package-card');
      
      cards.forEach(card => {
        card.addEventListener('touchstart', function() {
          this.style.opacity = '0.8';
        });
        
        card.addEventListener('touchend', function() {
          this.style.opacity = '1';
        });
      });
    });
  </script>
</body>
</html>