<?php
session_start();
include 'header.php';


// DB connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) die("Connection failed: " . $conn->connect_error);

// Get logged-in user email from session
if (!isset($_SESSION['email'])) {
    die("You must log in first.");
}

$user_email = $_SESSION['email'];

// Fetch user region
$user_query = $conn->prepare("SELECT region FROM users WHERE email = ?");
$user_query->bind_param("s", $user_email);
$user_query->execute();
$user_result = $user_query->get_result();
if ($user_result->num_rows === 0) {
    die("User not found.");
}
$user_data = $user_result->fetch_assoc();
$user_region = strtolower(trim($user_data['region'])); // Normalize case

// Get pad type ID from URL
$pad_type_id = $_GET['pad_type_id'] ?? null;
if (!$pad_type_id || !is_numeric($pad_type_id)) die("Invalid or missing pad type.");

// Fetch pad type name
$pad_type_stmt = $conn->prepare("SELECT name FROM pad_types WHERE id = ?");
$pad_type_stmt->bind_param("i", $pad_type_id);
$pad_type_stmt->execute();
$pad_type_result = $pad_type_stmt->get_result();
$pad_type = $pad_type_result->fetch_assoc();

// Determine price column based on region
$price_column = ($user_region === "region 2") ? "pp.price_region" : "pp.price";

// Fetch features and prices
$sql = "SELECT pf.name AS feature, $price_column AS price
        FROM pad_prices pp
        JOIN pad_features pf ON pf.id = pp.feature_id
        WHERE pp.pad_type_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $pad_type_id);
$stmt->execute();
$results = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
  <title><?= htmlspecialchars($pad_type['name']) ?> Prices</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #f8f9fa;
      font-family: Arial;
    }
    .feature-card {
      background: white;
      border-radius: 15px;
      padding: 15px;
      margin-bottom: 20px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.1);
      display: flex;
      align-items: center;
    }
    .pad-icon {
      height: 60px;
      width: 60px;
      object-fit: contain;
      margin-right: 15px;
      border-radius: 10px;
    }
    .cart-btn {
      background-color:#2c3169;
      border: none;
      padding: 5px 10px;
      margin-left: 29px;
      color: white;
      border-radius: 5px;
      font-size: 14px;
      cursor: pointer;
    }
    .cart-btn i {
      font-size: 16px;
    }
    .price{
     color: #70916a;
    font-weight: 700;
    }
  </style>
</head>
<body>
<div class="container py-5">
  <h3 class="text-center mb-4"><?= htmlspecialchars($pad_type['name']) ?> - Pad Price List</h3>

  <?php while ($row = $results->fetch_assoc()): ?>
    <div class="feature-card">
      <img src="images/family-album.gif" class="pad-icon" alt="Album Icon">
      <div>
        <h5 class="mb-1"><?= htmlspecialchars($row['feature']) ?>
          <button class="cart-btn" onclick='addToCart(<?= json_encode($row) ?>)'>
            <i class="bi bi-cart-plus"></i>
          </button>
        </h5>
        <p class="price">Price: ₹<?= number_format($row['price'], 2) ?></p>
      </div>
    </div>
  <?php endwhile; ?>
</div>

<script>
function addToCart(item) {
  let cart = JSON.parse(localStorage.getItem("cart") || "[]");
  cart.push(item);
  localStorage.setItem("cart", JSON.stringify(cart));
  alert("Added to cart: " + item.feature);
}
</script>

</body>
</html>
